

do $$
begin
	if exists (select 1 from pg_type where typname = 'rs_tab_desc_parceiro') then
		drop type public.rs_tab_desc_parceiro cascade;
	end if;
end$$;

create type public.rs_tab_desc_parceiro as
(   cd_tbl_desc   integer,
    tp_desc       integer,
    flag_desc_fix integer,
    perc_desc     double precision,
    perc_desc_max double precision,
    tp_nivel      integer 
);
	
alter type public.rs_tab_desc_parceiro
  owner to postgres;


grant usage on type public.rs_tab_desc_parceiro to public;

  

CREATE OR REPLACE FUNCTION public.ufd_est_prod_tbl_desc_parceiro(integer, integer, integer, integer, integer, integer)
RETURNS SETOF public.rs_tab_desc_parceiro AS
$body$
-- versao 23/09/2020

 --<<inicio do corpo da funcao
-- function: select * from ufd_est_prod_tbl_desc_parceiro_teste(1, 4, 1, 1, 5, 0)
--declara as variaveis usadas na funcao
declare

---------------------------------------------------------
----declara as variaveis que estao no cabecalho da funcao
---------------------------------------------------------
int_cd_emp              alias for $1;
int_cd_filial           alias for $2; 
int_cd_parceiro         alias for $3;
int_cd_prod             alias for $4; 
int_is_receita          alias for $5;
int_usa_desconto_propz_ident ALIAS FOR $6;
---------------------------------------------------------
---fim
---------------------------------------------------------

 
var_usa_desc_exclusivo 	integer;
var_tabelas_exclusivas 	integer;
 


returnrec rs_tab_desc_parceiro; --recebera os dados de retorno da funcao

 
begin --inicio dos blocos da funcao
 
	
	-------------------------------------------------------------------------------------------------------------------------------
	--declarando tabela temporaria de retorno
	-------------------------------------------------------------------------------------------------------------------------------
	begin
		create temporary table temp_rs_tab_desc_parceiro
		(	
			cd_tbl_desc 		integer,
			tp_desc 			integer,
			flag_desc_fix 		integer,
			perc_desc			double precision,
			perc_desc_max		double precision,
			tp_nivel			integer,
			dt_ini              timestamp without time zone 
		);
		exception when others then
		truncate table temp_rs_tab_desc_parceiro; -- trunca a tabela se ela já existir na corrente sessão.
	end;
	-------------------------------------------------------------------------------------------------------------------------------
	--declarando tabela que recebera as tbls vigentes
	-------------------------------------------------------------------------------------------------------------------------------
	begin
		create temporary table rs_tab_ativa_parceiro
		(	
			cd_emp 		integer,    
			cd_tbl_desc integer,    
			tp_desc 	integer
		);
		exception when others then
		truncate table rs_tab_ativa_parceiro; -- trunca a tabela se ela ja existir na corrente sessao.
	end;
	-------------------------------------------------------------------------------------------------------------------------------
	--declarando tabela de arvore mercadologica do produto
	-------------------------------------------------------------------------------------------------------------------------------
	begin
		create temporary table rs_est_prod_arv_merc
		(
			cd_emp					integer,
			cd_prod					integer,
			cd_arv_merc_categ		integer,
			cd_arv_merc_linha		integer,
			cd_mc					integer,
			cd_arv_merc_familia		integer,								
			cd_fabric				integer
		);--fim rs_est_prod_arv_merc
		exception when others then
		truncate table rs_est_prod_arv_merc; -- trunca a tabela se ela ja existir na corrente sessao.
	end;
	-------------------------------------------------------------------------------------------------------------------------------	
	---------------------------------------------------fim da criacao das tbls temporarias-----------------------------------------
	-------------------------------------------------------------------------------------------------------------------------------
	-------------------------------------------------------------------------------------------------------------------------------
	--buscando arvore merc. do produto
	-------------------------------------------------------------------------------------------------------------------------------	
	insert into rs_est_prod_arv_merc		
		select 
			   arv.cd_emp					,
			   arv.cd_prod					,
			   arv.cd_arv_merc_categ		,
			   arv.cd_arv_merc_linha		,
			   arv.cd_mc					,
			   arv.cd_arv_merc_familia		,												
			   p.cd_fabric 
		  from est_prod_est_arv_mercadologica arv 
			   inner join est_prod p on arv.cd_emp	=  p.cd_emp
									and arv.cd_prod = p.cd_prod	
		 where arv.cd_emp = int_cd_emp
		   and arv.cd_prod = int_cd_prod;
	
	
	
	
	-- verifica se o parceiro usa tabelas exclusivas 0 - Não | 1 - Sim 
	var_usa_desc_exclusivo = coalesce(( select desc_exclusivo_parceiro from glb_parceiro where cd_parceiro = int_cd_parceiro ), 0);
	raise notice 'var_usa_desc_exclusivo = %.',var_usa_desc_exclusivo;
	
	

	-- verifica se existe alguma tabela exclusiva configurada  0 - Nao | 1 - Sim 
    var_tabelas_exclusivas = coalesce(( select 1 from glb_parceiro_est_prod_tbl_desc where cd_parceiro = int_cd_parceiro limit 1  ), 0);
    raise notice 'var_tabelas_exclusivas = %.',var_tabelas_exclusivas;





	if exists (select 1 from rs_est_prod_arv_merc) then
	
		-- todas as tabelas que nao exite receita
		insert into rs_tab_ativa_parceiro    
			select  a.cd_emp,    
					a.cd_tbl_desc,    
					a.cd_tp_desconto
			  from est_prod_tbl_desc a  
			       inner join est_prod_tbl_desc_prc_filial fil on a.cd_emp = fil.cd_emp 
															  and a.cd_tbl_desc = fil.cd_tbl_desc
			 where int_cd_emp = a.cd_emp 
			   and int_cd_filial = fil.cd_filial 
			   and current_date between cast(a.dt_ini as date) and cast(a.dt_fim as date) 
			   and 1  = a.sts_tbl_desc 
			   and 31 = a.cd_tp_desconto 
			   and a.flag_desc_receita = 0
			   AND	(
						  ((int_usa_desconto_propz_ident = 1) AND (a.flag_tp_desconto_propz in (0,1))) OR 
						  ((int_usa_desconto_propz_ident = 0) AND (a.flag_tp_desconto_propz not in (1,2)))
						);
					
					
		-- inclui as tabelas que exite receita			
		if 	int_is_receita > 0 then	
		
			insert into rs_tab_ativa_parceiro    
				select  a.cd_emp,    
						a.cd_tbl_desc,    
						a.cd_tp_desconto
				  from est_prod_tbl_desc a 
					   inner join est_prod_tbl_desc_prc_filial fil on a.cd_emp = fil.cd_emp 
																  and a.cd_tbl_desc = fil.cd_tbl_desc
				 where int_cd_emp = a.cd_emp 
				   and int_cd_filial = fil.cd_filial 
				   and current_date between cast(a.dt_ini as date) and cast(a.dt_fim as date) 
				   and 1  = a.sts_tbl_desc 
				   and 31 = a.cd_tp_desconto 
				   and a.flag_desc_receita = 1
				   AND	(
						  ((int_usa_desconto_propz_ident = 1) AND (a.flag_tp_desconto_propz in (0,1))) OR 
						  ((int_usa_desconto_propz_ident = 0) AND (a.flag_tp_desconto_propz not in (1,2)))
						);
						
		end if;
		  
		
		if var_usa_desc_exclusivo = 1 then  
			if var_tabelas_exclusivas = 1 then 
		   
			    delete from rs_tab_ativa_parceiro a 
			     where not exists (select b.cd_emp
			          				 from glb_parceiro_est_prod_tbl_desc b  
			    	    			where b.cd_emp        = a.cd_emp
			    	    			  and b.cd_tbl_desc   = a.cd_tbl_desc   
			    	    			  and b.cd_parceiro   = int_cd_parceiro  
			    	    			    ) ;
		    end if ; 
		end if ; 

	 -- Caso parceiro (B) tenha tabelas exclusivas, essa tabela não pode cair para o parceiro (A)
			    delete from rs_tab_ativa_parceiro a 
			     where     exists (select b.cd_emp
			          				 from glb_parceiro_est_prod_tbl_desc b  
			    	    			where b.cd_emp        = a.cd_emp
			    	    			  and b.cd_tbl_desc   = a.cd_tbl_desc   
			    	    			  and b.cd_parceiro   <> int_cd_parceiro ) ;	
		
		
		
		
		
				
		if exists (select 1 from rs_tab_ativa_parceiro) then
			-------------------------------------------------------------------------------------------------------------------------------    
			--CONSULTANDO AS TBLS DE DESCONTO PARA VERIFICAR SE HA ALGUM DESCONTO NO NIVEL 1 - PRODUTOS    
			-------------------------------------------------------------------------------------------------------------------------------    
			insert into temp_rs_tab_desc_parceiro     
				  select    
						a.cd_tbl_desc    as cd_tbl_desc,    
						a.cd_tp_desconto as tp_desc,    
						a.flag_desc_fix  as flag_desc_fix,    
						b.perc_desc      as perc_desc,    
						b.perc_desc_max  as perc_desc_max,    
						1                as tp_nivel,
						a.dt_ini 
				   from est_prod_tbl_desc a
				      --  inner join est_prod_tbl_desc_qtde_acima e on a.cd_emp      = e.cd_emp 
					  --											 and a.cd_tbl_desc = e.cd_tbl_desc 
						inner join est_prod_tbl_desc_est_prod b on a.cd_emp      = b.cd_emp 
															   and a.cd_tbl_desc = b.cd_tbl_desc    
						inner join est_prod_tbl_desc_prc_filial fil on b.cd_emp      = fil.cd_emp 
																   and b.cd_tbl_desc = fil.cd_tbl_desc    
						inner join rs_tab_ativa_parceiro on b.cd_emp      = rs_tab_ativa_parceiro.cd_emp 
												        and b.cd_tbl_desc     = rs_tab_ativa_parceiro.cd_tbl_desc     
						inner join rs_est_prod_arv_merc arv on b.cd_emp  = arv.cd_emp 
														   and b.cd_prod = arv.cd_prod           
				  where int_cd_filial = fil.cd_filial ;
	
	
			-------------------------------------------------------------------------------------------------------------------------------    
			--CONSULTANDO AS TBLS DE DESCONTO PARA VERIFICAR SE HA ALGUM DESCONTO NO NIVEL 2 - FAMILIAS    
			-------------------------------------------------------------------------------------------------------------------------------    
			insert into temp_rs_tab_desc_parceiro     
				select   
					   a.cd_tbl_desc    as cd_tbl_desc,    
					   a.cd_tp_desconto as tp_desc,    
					   a.flag_desc_fix  as flag_desc_fix,        
					   b.perc_desc      as perc_desc,    
					   b.perc_desc_max  as perc_desc_max,   
					   2                as tp_nivel,
					   a.dt_ini     
				  from est_prod_tbl_desc a
						--inner join est_prod_tbl_desc_qtde_acima e on a.cd_emp = e.cd_emp 
						--									     and a.cd_tbl_desc = e.cd_tbl_desc
						inner join est_prod_tbl_desc_est_arv_merc_familia b on a.cd_emp = b.cd_emp 
																		   and a.cd_tbl_desc = b.cd_tbl_desc    
						inner join est_prod_tbl_desc_prc_filial fil on b.cd_emp = fil.cd_emp 
																   and b.cd_tbl_desc = fil.cd_tbl_desc    
						inner join rs_est_prod_arv_merc arv on b.cd_emp = arv.cd_emp 
														   and b.cd_arv_merc_familia = arv.cd_arv_merc_familia    
						inner join rs_tab_ativa_parceiro on a.cd_emp      = rs_tab_ativa_parceiro.cd_emp 
													    and b.cd_tbl_desc = rs_tab_ativa_parceiro.cd_tbl_desc        
				 where int_cd_filial = fil.cd_filial ;
			
			
			
			-------------------------------------------------------------------------------------------------------------------------------        
			--CONSULTANDO AS TBLS DE DESCONTO PARA VERIFICAR SE HA ALGUM DESCONTO NO NIVEL 3 - MARCAS    
			-------------------------------------------------------------------------------------------------------------------------------    
			insert into temp_rs_tab_desc_parceiro     
				select
					   a.cd_tbl_desc    as cd_tbl_desc,    
					   a.cd_tp_desconto as tp_desc,    
					   a.flag_desc_fix  as flag_desc_fix,       
					   b.perc_desc      as perc_desc,    
					   b.perc_desc_max  as perc_desc_max,   
					   3                as tp_nivel,
					   a.dt_ini   
				  from est_prod_tbl_desc a
					--   inner join est_prod_tbl_desc_qtde_acima e on a.cd_emp = e.cd_emp 
					--											and a.cd_tbl_desc = e.cd_tbl_desc   
					   inner join est_prod_tbl_desc_est_mc b on a.cd_emp = b.cd_emp 
					   									    and a.cd_tbl_desc = b.cd_tbl_desc    
					   inner join est_prod_tbl_desc_prc_filial fil on b.cd_emp = fil.cd_emp 
					   										      and b.cd_tbl_desc = fil.cd_tbl_desc    
					   inner join rs_est_prod_arv_merc arv on b.cd_emp = arv.cd_emp 
					   								      and b.cd_mc  = arv.cd_mc    
					   inner join rs_tab_ativa_parceiro on a.cd_emp     = rs_tab_ativa_parceiro.cd_emp 
					   							      and b.cd_tbl_desc = rs_tab_ativa_parceiro.cd_tbl_desc        
				 where int_cd_filial = fil.cd_filial ;
			
			
			
			-------------------------------------------------------------------------------------------------------------------------------    
			--CONSULTANDO AS TBLS DE DESCONTO PARA VERIFICAR SE HA ALGUM DESCONTO NO NIVEL 4 - FABRICANTES    
			-------------------------------------------------------------------------------------------------------------------------------    
			insert into temp_rs_tab_desc_parceiro     
				select   
					   a.cd_tbl_desc    as cd_tbl_desc,    
					   a.cd_tp_desconto as tp_desc,    
					   a.flag_desc_fix  as flag_desc_fix,        
					   b.perc_desc      as perc_desc,    
					   b.perc_desc_max  as perc_desc_max,   
					   4                as tp_nivel,
					   a.dt_ini    
				  from est_prod_tbl_desc a
					--   inner join est_prod_tbl_desc_qtde_acima e on a.cd_emp = e.cd_emp 
					--											and a.cd_tbl_desc = e.cd_tbl_desc   
					   inner join est_prod_tbl_desc_est_prod_fabric b on a.cd_emp = b.cd_emp 
																	 and a.cd_tbl_desc = b.cd_tbl_desc    
					   inner join est_prod_tbl_desc_prc_filial fil on b.cd_emp = fil.cd_emp 
																  and b.cd_tbl_desc = fil.cd_tbl_desc    
					   inner join rs_est_prod_arv_merc arv on b.cd_emp = arv.cd_emp 
														  and b.cd_fabric = arv.cd_fabric     
					   inner join rs_tab_ativa_parceiro on b.cd_emp      = rs_tab_ativa_parceiro.cd_emp 
												       and b.cd_tbl_desc = rs_tab_ativa_parceiro.cd_tbl_desc        
				  where int_cd_filial = fil.cd_filial;
				
				
				
			------------------------------------------------------------------------------------------------------------------------------    
			--CONSULTANDO AS TBLS DE DESCONTO PARA VERIFICAR SE HA ALGUM DESCONTO NO NIVEL 5 - CATEGORIAS        
			-------------------------------------------------------------------------------------------------------------------------------    
			insert into temp_rs_tab_desc_parceiro     
				select   
					   a.cd_tbl_desc    as cd_tbl_desc,    
					   a.cd_tp_desconto as tp_desc,    
					   a.flag_desc_fix  as flag_desc_fix ,    
					   b.perc_desc      as perc_desc,    
					   b.perc_desc_max  as perc_desc_max,   
					   5                as tp_nivel,
					   a.dt_ini  
				  from est_prod_tbl_desc a
					--  inner join est_prod_tbl_desc_qtde_acima e on a.cd_emp = e.cd_emp 	
					--										    and a.cd_tbl_desc = e.cd_tbl_desc    
					   inner join est_prod_tbl_desc_est_arv_merc_categoria b on a.cd_emp = b.cd_emp 
																			and a.cd_tbl_desc = b.cd_tbl_desc    
					   inner join est_prod_tbl_desc_prc_filial fil on b.cd_emp = fil.cd_emp 
																  and b.cd_tbl_desc = fil.cd_tbl_desc    
					   inner join rs_est_prod_arv_merc arv on b.cd_emp = arv.cd_emp 
														  and b.cd_arv_merc_categ = arv.cd_arv_merc_categ    
					   inner join rs_tab_ativa_parceiro on a.cd_emp      = rs_tab_ativa_parceiro.cd_emp 
												       and b.cd_tbl_desc = rs_tab_ativa_parceiro.cd_tbl_desc        
				 where int_cd_filial = fil.cd_filial;
				
				
				
			-------------------------------------------------------------------------------------------------------------------------------    
			--CONSULTANDO AS TBLS DE DESCONTO PARA VERIFICAR SE HA ALGUM DESCONTO NO NIVEL 6 - LINHAS
			-------------------------------------------------------------------------------------------------------------------------------    
			insert into temp_rs_tab_desc_parceiro     
				select   
					   a.cd_tbl_desc    as cd_tbl_desc,    
					   a.cd_tp_desconto as tp_desc,    
					   a.flag_desc_fix  as flag_desc_fix ,   
					   b.perc_desc      as perc_desc,    
					   b.perc_desc_max  as perc_desc_max,   
					   6                as tp_nivel,
					   a.dt_ini  
				  from est_prod_tbl_desc a
					--  inner join est_prod_tbl_desc_qtde_acima e on a.cd_emp = e.cd_emp 
					--										    and a.cd_tbl_desc = e.cd_tbl_desc    
					   inner join est_prod_tbl_desc_est_arv_merc_linha b on a.cd_emp = b.cd_emp 
						 											    and a.cd_tbl_desc = b.cd_tbl_desc    
					   inner join est_prod_tbl_desc_prc_filial fil on b.cd_emp = fil.cd_emp 
						 									      and b.cd_tbl_desc = fil.cd_tbl_desc    
					   inner join rs_est_prod_arv_merc arv on b.cd_emp = arv.cd_emp 
													      and b.cd_arv_merc_linha = arv.cd_arv_merc_linha    
					   inner join rs_tab_ativa_parceiro on a.cd_emp      = rs_tab_ativa_parceiro.cd_emp 
												       and b.cd_tbl_desc = rs_tab_ativa_parceiro.cd_tbl_desc        
				 where int_cd_filial = fil.cd_filial;
				   
						
		end if;--if exists (select 1 from rs_tab_ativa_parceiro) then
	end if; --if exists (select 1 from rs_est_prod_arv_merc) then
	
	 
	-------------------------------------------------------------------------------------------------------------------------------
	-- RETORNANDO DESCONTO LIMITE (RESULTADO DA FUNCAO)
	-------------------------------------------------------------------------------------------------------------------------------
    for returnrec in 
		select cd_tbl_desc, 
		       tp_desc, 
			   1 flag_desc_fix, 
			   perc_desc, 
			   perc_desc_max, 
			   tp_nivel 
		  from temp_rs_tab_desc_parceiro 
		 order by  tp_nivel asc, perc_desc desc , dt_ini desc limit 1

		 loop
		return next returnrec;
	end loop;
 
 				
end; --fim dos blocos da funcao
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
PARALLEL UNSAFE
COST 100 ROWS 1000;

CREATE OR REPLACE FUNCTION public.ufd_est_prod_tbl_desc_parceiro(integer, integer, integer, integer, integer)
RETURNS SETOF public.rs_tab_desc_parceiro AS
$body$
DECLARE RET rs_tab_desc_parceiro;
BEGIN
  RET = ufd_est_prod_tbl_desc_parceiro($1, $2, $3, $4, $5, 0);
  RETURN NEXT RET;
END
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
PARALLEL UNSAFE
COST 100 ROWS 1000;